const SW_CONTENT = `
// **proxy-sw.js**：Service Worker 流量拦截 (Production Optimized)
const VERSION = '2.0.0';

self.addEventListener('install', event => self.skipWaiting());
self.addEventListener('activate', event => event.waitUntil(self.clients.claim()));

self.addEventListener('fetch', event => {
    const req = event.request;
    const url = new URL(req.url);

    // 排除本站请求、API 请求或已经代理过的请求
    if (url.origin === location.origin || req.url.includes('/index.php?')) {
        return;
    }

    // 仅拦截跨域请求
    // 构造代理 URL：本站域名 + /index.php?u=Base64
    const targetUrl = btoa(req.url).replace(/\\+/g, '-').replace(/\\//g, '_').replace(/=+$/, '');
    const proxyUrl = \`\${location.origin}/index.php?u=\${targetUrl}\`;

    event.respondWith(
        fetch(proxyUrl, {
            headers: req.headers,
            mode: 'cors',
            credentials: 'omit'
        }).catch(() => {
            // 如果代理失败（例如网络问题），尝试直连（虽然可能跨域失败，但作为最后手段）
            return fetch(req);
        })
    );
});
`;

// Service Worker 注册代码
const JS_SW_REGISTRATION = `
(function() {
    if ('serviceWorker' in navigator) {
        window.addEventListener('load', () => {
            // 使用 Blob 对象创建 Service Worker 文件内容
            const swBlob = new Blob([${JSON.stringify(SW_CONTENT)}], { type: 'application/javascript' });
            const swUrl = URL.createObjectURL(swBlob);
            
            navigator.serviceWorker.register(swUrl, { scope: '/' })
                .then(reg => console.log('SW registered:', reg.scope))
                .catch(err => console.log('SW registration failed:', err));
        });
    }
})();
`;